
on getAccounts()
	tell application id "com.apple.Mail" to return accounts
end getAccounts

on getName(theRef)
	tell application id "com.apple.Mail" to return name of theRef
end getName

on getMailboxes()
	local theMailbox, theMailboxes
	tell application id "com.apple.Mail"
		set theMailboxes to {}
		repeat with theMailbox in mailboxes
			set theContainer to theMailbox's container
			try
				get container of theContainer
			on error
				set end of theMailboxes to theMailbox
			end try
		end repeat
		return theMailboxes
	end tell
end getMailboxes

on getAccountSubMailboxes(theMailbox)
	tell application id "com.apple.Mail"
		local theMailboxes, childMailbox, theContainer
		set theMailboxes to {}
		repeat with childMailbox in mailboxes of theMailbox
			try
				set theContainer to container of childMailbox
				if theContainer is equal to account of childMailbox or name of theContainer is equal to "[Gmail]" then set end of theMailboxes to childMailbox
			end try
		end repeat
		return theMailboxes
	end
end getAccountSubMailboxes

on getSubMailboxes(theMailbox)
	tell application id "com.apple.Mail" to return mailboxes of theMailbox
end getSubMailboxes

on getMailboxMessageCount(theMailbox)
	try
		tell application id "com.apple.Mail" to return count of messages of theMailbox
	end try
	return 0
end getMailboxMessageCount

on getMailboxUnreadMessageCount(theMailbox)
	try
		tell application id "com.apple.Mail" to return unread count of theMailbox
	end try
	return 0
end getMailboxUnreadMessageCount

on getMailboxMessages(theMailbox)
	try
		tell application id "com.apple.Mail" to return messages of theMailbox
	end try
	return {}
end getMailboxMessages

on getMailboxType(theMailbox)
	try
		local draftsMailbox, sentMailbox, theName
		tell application id "com.apple.Mail"
			set sentMailbox to sent mailbox
			if theMailbox is equal to sentMailbox then return "sent"
			set theName to (name of theMailbox as string)
			if (name of mailboxes of sentMailbox) contains theName then return "sent"

			(* set draftsMailbox to drafts mailbox
			if theMailbox is equal to draftsMailbox then return "drafts"
			if (name of mailboxes of draftsMailbox) contains theName then return "drafts" *)
		end tell
	end try
	return ""
end getMailboxType

on getMessageProperties(theMessage)
	tell application id "com.apple.Mail"
		tell theMessage
			return {|source|:source, |dateReceived|:date received, deleted:deleted status, flagged:flagged status, junk:junk mail status, |read|:read status}
		end tell
	end tell
end getMessageProperties

on getMessageSource(theMessage)
	tell application id "com.apple.Mail" to return source of theMessage
end getMessageSource

on getSelectedMessages()
	tell application id "com.apple.Mail" to return selection
end

on getSelectedMailboxes()
	tell application id "com.apple.Mail" to return selected mailboxes of message viewer 1
end

on setOffline(theFlag)
	tell application id "com.apple.Mail" to set fetches automatically to theFlag
end
